from math import log,log2, factorial

def bit_cmp (x, y):
    n = x ^ y
    return sum([int(b) for b in bin(n)[2:]])

def n_choose_k (nb, k):
    '''nb!/k!(nb-k)!'''
    if nb < k: return 0
    return int(factorial(nb)/(factorial(k)*factorial(nb-k)))

class entropy (object):
    '''Shannon Entropy Calculator class.'''
    def __init__ (self, nbr_of_bits):
        self.nb = nbr_of_bits
        self.np = pow(2,self.nb)
    def pf (self, x):
        '''Probability Function. (Override in subclass!)'''
        return 1.0
    def __call__ (self):
        '''Generate and print results.'''
        self.ns = [n_choose_k(self.nb,k) for k in range(self.nb+1)]
        # Normalized Probability Factors...
        self.fs = [self.pf(x) for x in range(self.nb+1)]
        self.ts = [n*f for n,f in zip(self.ns,self.fs)]
        self.tp = sum(self.ts)
        self.ps = [f/self.tp for f in self.fs]
        # Calculate Shannon entropy...
        self.xs = [self.ps[bit_cmp(0,p)] for p in range(self.np)]
        self.es = [x*log2(x) for x in self.xs]
        self.ent = -sum(self.es)
        self.tpx = sum(self.xs)
        # Print results...
        print(str(self))
        print()
        for ix,rcd in enumerate(zip(self.ns,self.fs,self.ts,self.ps)):
            print('%2d:%6d %12.4e %12.4e %14.6e' % ((ix,)+rcd))
        print()
        print('PF(EXP)=%.8f (tp=%.6f)' % (self.ps[0], self.tp))
        print('entropy=%.8f (tp=%.6f)' % (self.ent, self.tpx))
        print()
        return self.ent
    def __str__ (self):
        return '#bits:%d, #patterns:%d' % (self.nb, self.np)

class entropy1 (entropy):
    def __init__ (self, nbits, divisor):
        super().__init__(nbits)
        self.prob = 1.0/float(divisor if divisor else self.np)
    def pf (self, x):
        return self.prob

class entropy2 (entropy):
    def __init__ (self, nbits, probability):
        super().__init__(nbits)
        self.prob = 1.0/float(probability)
    def pf (self, x):
        return (1.0 if x==0 else self.prob)

class entropy3 (entropy):
    def __init__ (self, nbits, factor):
        super().__init__(nbits)
        self.fact = float(factor)
    def pf (self, x):
        return (1.0/pow(self.fact,x))

def demo_entropy_class (NB=8):
        e0 = entropy(NB)
        e1 = entropy1(NB, 5.0)
        e2 = entropy2(NB, 1e6)
        e3 = entropy3(NB, 250)
        e0()
        e1()
        e2()
        e3()
        return (e0,e1,e2,e3)

