from random import randint

def demo_shannon_curve (NB=5):
    '''Shannon Entropy curve for P(X).'''
    extra = [0.999999, 0.9999999]
    NP = pow(2,NB)
    X = randint(1, NP-1)
    print('NB=%d, NP=%d' % (NB,NP))
    print('X=%d' % X)
    print()
    # P(X) goes from 1/NP thru (NP-1)/NP...
    ps = [n/NP for n in range(1,NP)]
    # Loop over probabilities for P(X)...
    for ix,p in enumerate(ps+extra):
        PF = lambda x:p if x==X else ((1.0-p)/(NP-1))
        ent,_,tp,_ = shannon_entropy(NP, PF)
        print('%4d: %.9f = %.12f (%.6f)' % (1+ix, p, ent, tp))
    print()

