from random import randint

def demo_shannon_entropy (NB=5, p_of_x=None):
    '''Shannon entropy for a specific P(X).'''
    NP = pow(2,NB)
    PF = (1.0/NP) if p_of_x is None else p_of_x
    PX = randint(1, NP-1)
    probs = lambda x:PF if x==PX else ((1.0-PF)/(NP-1))
    ent,_,tprob,_ = shannon_entropy(NP, probs)
    print()
    print('NB=%d, NP=%d' % (NB,NP))
    print('P(PX)=PF=%.12f' % PF)
    print('tot-prob=%.12f' % tprob)
    print('entropy=%.12f' % ent)
    print()
    return ent

