from math import log

def shannon_entropy (NP, PF, logbase=2):
    '''Calculate the Shannon Entropy given PF(x).'''
    # Generate probabilities...
    probs = [PF(x) for x in range(NP)]
    tprob = sum(probs) # expected to be 1.000
    # Generate summation terms...
    ents = [p*log(p,logbase) for p in probs]
    ent = -sum(ents)
    # Return all the generated data...
    return (ent, ents, tprob, probs)

def demo_shannon_entropy (n_patts=27):
    probfunc = lambda x:1/float(n_patts)
    ent,_,tp,_ = shannon_entropy(n_patts, probfunc)
    print(ent)
    print(tp)
    print()

