class TuringMachine (object):
    def __init__ (self, program, max_steps=32, blank=0):
        self.program = program
        self.max_steps = max_steps
        self.state = 0
        self.watchdog = 1
        self.tape = TuringTape(blank=blank)
    def reset (self):
        self.state = 0
        self.watchdog = 1
        self.tape.reset()
    def run (self):
        while 0 <= self.state:
            pe = self._find_pgm_entry()
            d = 'L' if pe[3]<0 else 'R'
            x = 'HALT' if pe[4] < 0 else ('S%d' % pe[4])
            s = '%2d: S%d [%d] {%d,%s} (%s)'
            t = (self.watchdog, self.state, self.tape.curr(), pe[2],d, x)
            print(s % t)
            self.tape(pe[2], pe[3])
            self.state = pe[4]
            self.watchdog += 1
            if self.max_steps < self.watchdog:
                break
        # Trim (we assume) unused tape ends...
        self.tape._trim()
        out = [(t0,t1) for t0,t1 in self.tape.tape if t1]
        # Generate a nice print string...
        ps0 = 'HALT' if self.state < 0 else ('S%d' % self.state)
        ps2 = ' '.join([str(t[0]) for t in out])
        print('- ')
        print('%s (%d) [%s]' % (ps0, len(out), ps2))
        print()
        # Return final state and tape...
        return (self.state, out)
    def __str__ (self):
        return ''
    def _find_pgm_entry (self):
        for pe in self.program:
            if (pe[0]==self.state) and (pe[1]==self.tape.curr()):
                return pe
        raise KeyError('No Program Entry!')

