class TuringTape (object):
    def __init__ (self, blank=0):
        self.blank = blank
        self.reset()
    def reset (self):
        self.head = 0
        self.tape = [[self.blank, 0]]
    def curr (self):
        return self.tape[self.head][0]
    def __call__ (self, cell, move):
        _cell = int(cell)
        _move = int(move)
        # Write to the tape...
        self.tape[self.head][0] = _cell
        self.tape[self.head][1] += 1
        # Move forwards...
        if 0 < _move:
            self.head += 1
            # Append another cell if necessary...
            if len(self.tape) <= self.head:
                self.tape.append([self.blank,0])
                return
        # Move backwards...
        if _move < 0:
            self.head -= 1
            # Insert another cell if necessary...
            if self.head < 0:
                self.head = 0
                self.tape.insert(0, [self.blank,0])
                return
        # Don't move (_move==0)...
    def __len__ (self):
        return len(self.tape)
    def __str__ (self):
        t = ' '.join([str(t0) for t0,t1 in self.tape if t1])
        return '[%s]' % t
    def _trim (self):
        while (1 < len(self)) and (self.tape[-1][1] == 0):
            self.tape.pop(-1)
        while (1 < len(self)) and (self.tape[0][1] == 0):
            self.tape.pop(0)

