def turing_tape (tape, Blank=0):
    '''Turing Machine Tape (Python generator)'''
    head = 0
    while True:
        _tval,_move = yield tape[head][0]
        tval = int(_tval)
        move = int(_move)
        # Write to the tape...
        tape[head][0] = tval
        tape[head][1] += 1
        # Move forwards...
        if 0 < move:
            head += 1
            # Append another cell if necessary...
            if len(tape) <= head:
                tape.append([Blank,0])
                continue
        # Move backwards...
        if move < 0:
            head -= 1
            # Insert another cell if necessary...
            if head < 0:
                head = 0
                tape.insert(0, [Blank,0])
                continue
        # Don't move (move==0)...

