def turing_machine (program, max_steps=32):
    '''TM. program=(state,key,write,move,next)'''
    outfmt = '%2d: S%d [%d] {%d,%s} (%s)'
    def find_pgm_entry (_state, _curr):
        for pe in program:
            if (pe[0]==_state) and (pe[1]==_curr):
                return pe
        raise KeyError('No Program Entry!')

    tape = [[0,0]]
    tt = turing_tape(tape)
    curr = tt.send(None) # start the tape

    state = 0
    watchdog = 1
    while 0 <= state:
        # Find appropriate program statement...
        pe = find_pgm_entry(state,curr)
        # Do some pretty-print stuff...
        d = 'L' if pe[3]<0 else 'R'
        x = 'HALT' if pe[4] < 0 else ('S%d' % pe[4])
        out = (watchdog, state, curr, pe[2],d, x)
        # Print current system state...
        print(outfmt % out)
        # ACTION: Write/move tape...
        curr = tt.send(pe[2:4])
        # Move to next state...
        state = pe[4]
        # Quit if we've been doing this too long...
        watchdog += 1
        if max_steps < watchdog:
            break
    # Trim unused tape ends...
    out = [(t0,t1) for t0,t1 in tape if t1]
    # Generate a nice print string...
    ps0 = 'HALT' if state < 0 else ('S%d' % state)
    ps2 = ' '.join([str(t[0]) for t in out])
    print('- ')
    print('%s (%d) [%s]' % (ps0, len(out), ps2))
    print()
    # Return final state and tape...
    return (state, out)

