from examples import linefile

class srcfile (linefile):
    '''Source Code File class. Auto-skips blank lines and comments.'''
    def __init__ (self, filename, rems=None):
        super().__init__(filename)
        self.rems = rems if rems else [';', '#', '//', '--']
        self.src = []

    def load (self):
        '''Load Source Code file. (Code lines will be in a list.)'''
        # Delegate loading lines of text to parent...
        super().load()

        # Scan file lines for blank lines and comments...
        for line in self.data:
            # Ignore leading and trailing spaces...
            test = line.strip()

            # Skip blank lines...
            if len(test) == 0:
                continue

            # Skip lines beginning with rem char...
            rem_flag = 0
            for rem in self.rems:
                if test.startswith(rem):
                    rem_flag = 1
                    break
            if rem_flag:
                continue

            # Add the line to the src code...
            self.src.append(line)

    def save (self):
        raise NotImplementedError()

fn = r'C:\demo\hcc\python\vim.txt'
fo = srcfile(fn, rems=['"'])
fo.load()

for ix,line in enumerate(fo.src):
    print(f'{ix+1:02d}: {line}')
print()

