from json import load as jsonload, dump as jsonsave
from examples import filecontent

class jsonfile (filecontent):
    '''JSON (Text) File class.'''

    def __init__ (self, filename):
        ''' New JSON File instance.'''
        super().__init__(filename)
        self.data = {}

    def load (self):
        '''Load JSON file. (Data will be a dictionary.)'''
        fp = open(self.fullname, mode='rb')
        try:
            # Load a JSON file...
            self.data = jsonload(fp)
        except:
            raise
        else:
            print(f'read: {self.fullname}')
        finally:
            fp.close()

    def save (self, indent=3):
        '''Save JSON file. (Data must be a dictionary.)'''
        fp = open(self.fullname, mode='w')
        try:
            # Write a JSON file...
            jsonsave(self.data, fp, indent=indent)
        except:
            raise
        else:
            print(f'wrote: {self.fullname}')
        finally:
            fp.close()

fn = r'C:\demo\hcc\python\example.json'
fo = jsonfile(fn)
fo.load()

print(fo)
print()
print(f'{len(fo)=} (# of top-level dicts)')
print(f'Top-level dicts: {list(fo.data.keys())}')
print()
print(f'{fo.data["version"]=}')
print(f'{fo.data["head"]["title"]=}')
print()

