from examples import filecontent

class linefile (filecontent):
    '''Line-oriented Text File class.'''

    def __init__ (self, filename):
        ''' New Text File instance.'''
        super().__init__(filename)
        self.data = []

    def __call__ (self):
        '''Calling object returns lines as single string.'''
        return '\n'.join(self.data)

    def add (self, txt=''):
        '''Add's a new line to the end of the data.'''
        self.data.append(txt)

    def load (self, encoding='utf-8'):
        '''Load text file. (Data will be a list of strings.)'''
        fp = open(self.fullname, mode='r', encoding=encoding)
        try:
            # Read lines from file...
            self.data = [s.rstrip() for s in fp]

            # Check for a Unicode BOM...
            if 0 < len(self.data):
                if 0 < len(self.data[0]):
                    if self.data[0][0] == '\ufeff':
                        self.data[0] = self.data[0][1:]
        except:
            raise
        else:
            print(f'read: {self.fullname}')
        finally:
            fp.close()

    def save (self, encoding='utf-8', use_bom=False):
        '''Save text file. (Data must be a list of strings.)'''
        fp = open(self.fullname, mode='w', encoding=encoding)
        try:
            # Optional Unicode BOM marker...
            if use_bom:
                fp.write('\ufeff')

            # Write lines to file...
            for s in self.data:
                fp.write(s)
                fp.write('\n')
        except:
            raise
        else:
            print(f'wrote: {self.fullname}')
        finally:
            fp.close()

fn = r'C:\demo\hcc\python\the-dream.txt'
fo = linefile(fn)
fo.load()

print()
print(f'{fo.filename=}')
print(f'{len(fo)=}')
print(f'{fo[3:5]=}')
print()
for line in fo:
    print(line)
    if line.startswith('I dreamed'):
        break
print()

