from examples import filecontent

class textfile (filecontent):
    '''Generic Text File class.'''

    def __init__ (self, filename):
        ''' New Text File instance.'''
        super().__init__(filename)
        self.data = str()

    def load (self, encoding='utf-8'):
        '''Load text file. (Data will be a single string.)'''
        fp = open(self.fullname, mode='r', encoding=encoding)
        try:
            # Read string from file...
            self.data = fp.read()

            # Check for a Unicode BOM...
            if self.data[0] == '\ufeff':
                # Remove it if found...
                self.data = self.data[1:]
        except Exception as e:
            print(e)
            raise
        else:
            print(f'read: {self.fullname}')
        finally:
            fp.close()

    def save (self, encoding='utf-8', use_bom=False):
        '''Save text file. (Data must be a single string.)'''
        fp = open(self.fullname, mode='w', encoding=encoding)
        try:
            # Optional Unicode BOM marker...
            if use_bom:
                fp.write('\ufeff')

            # Write string to file...
            fp.write(self.data)
        except Exception as e:
            print(e)
            raise
        else:
            print(f'wrote: {self.fullname}')
        finally:
            fp.close()

    def __contains__ (self, item): return (item in self.data)

from os import path

BasePath = r'C:\demo\hcc\python'
filename = r'the-dream.txt'

fn = path.join(BasePath, filename)
fo = textfile(fn)
fo.load()

print()
print(f'{fo.filename=}')
print(f'{len(fo)=}')
print(f'{fo[0:60]=}')
print(f'{fo[100]=}')
print(f'{"house" in fo=}')
print(f'{"foobar" in fo=}')
nbr_of_spaces = 0
for ch in fo:
    if ch == ' ':
        nbr_of_spaces += 1
print(f'{nbr_of_spaces=}')
print()

