from examples import filecontent

class datafile (filecontent):
    '''Generic Data File class.'''

    def __init__ (self, filename):
        ''' New Data File instance.'''
        super().__init__(filename)
        self.data = None

    def load (self):
        '''Load data file. (Data will be bytes.)'''
        fp = open(self.fullname, mode='rb')
        try:
            self.data = fp.read()
        except Exception as e:
            print(e)
            raise
        else:
            print(f'read: {self.fullname}')
        finally:
            fp.close()

    def save (self, data=None):
        '''Save data file. (Data must be bytes.)'''
        fp = open(self.fullname, mode='wb')
        try:
            fp.write(self.data)
        except Exception as e:
            print(e)
            raise
        else:
            print(f'wrote: {self.fullname}')
        finally:
            fp.close()

    def __contains__ (self, item): return (item in self.data)

from os import path

BasePath = r'C:\demo\hcc\python'
filename = r'colors.png'

fn = path.join(BasePath, filename)
fo = datafile(fn)
fo.load()

print()
print(f'{fo.filename=}')
print(f'{len(fo)=}')
print(f'{fo[0:10]=}')
print(f'{fo[9]=}')
for b in fo:
    print(f'{b=:02x}')
    if b == ord('\n'):
        break
print()

