from math import sqrt

def distance (point1, point2):
    '''Pythagorean distance between points.'''
    vector = [p2-p1 for p1,p2 in zip(point1, point2)]
    squares = [pow(d,2) for d in vector]
    return sqrt(sum(squares))

print(distance([0,0], [3,5]))
print(distance([1,2], [4,7]))
print(distance([1,1], [-1,-1]))
print(distance([3,5], [4,6]))
print()

